package gov.va.med.mhv.vitals.validator;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.util.MessagesUtil;

@Component
public class HeartRateValidator  extends Validator{
	
	public static  final int COMMENTS_MAX_LENGTH = 255;
	private static final Integer HEARTRATE_MIN_VALUE = new Integer("10");
	private static final Integer HEARTRATE_MAX_VALUE = new Integer("999");
	public static final String HEART_RATE = "Heart Rate ";


	
	@Autowired
	private MessagesUtil messages;
	
	public void heartRateValidations(ResponseUtil response, HeartRateReadingDTO hrdto) {
		fieldValidation(response, hrdto);
	}
	
	protected void fieldValidation(ResponseUtil response, HeartRateReadingDTO hrdto) {
		validateComments(response,hrdto);
		validateHeartRate(response,hrdto);
		validateDateEntered(response,hrdto);
		validateUserProfile(response,hrdto);
	}

	private void validateUserProfile(ResponseUtil response,	HeartRateReadingDTO hrdto) {
		if( hrdto.getUserprofileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(hrdto.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
	}

	private void validateDateEntered(ResponseUtil response,	HeartRateReadingDTO hrdto) {
		Date value = hrdto.getReading();
		if( value == null ) {
			Validations.validateRequired("dateEntered", value, response.getValidationErrors());
			return;
		}		
	}

	private void validateHeartRate(ResponseUtil response, HeartRateReadingDTO hrdto) {
		Integer value = hrdto.getHeartRate();
		if( value == null ) {
			Validations.validateRequired(HEART_RATE, value, response.getValidationErrors());
			return;
		}		
		
		Validations.validateMinValue("heartrate minimum", value, HEARTRATE_MIN_VALUE,HEART_RATE, response.getValidationErrors());
		Validations.validateMaxValue("heartrate maximum",value, HEARTRATE_MAX_VALUE,HEART_RATE,response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response, HeartRateReadingDTO hrdto) {
		String value = hrdto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}	

}
